﻿#nullable enable
namespace Hims.Shared.Library
{
    using System;
    /// <summary>
    /// The resource model.
    /// </summary>
    public class OutReport
    {
        /// <summary>
        /// Gets or sets the Provider id.
        /// </summary>
        public string? ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the Provider id.
        /// </summary>
        public string? PatientGender { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public string? FromDate { get; set; }

        /// <summary>
        /// Gets or sets the optional text 2.
        /// </summary>
        public string? ToDate { get; set; }

        /// <summary>
        /// Gets or sets the Provider id.
        /// </summary>
        public string? ProviderAge { get; set; }


        /// <summary>
        /// Gets or sets the Provider id.
        /// </summary>
        public string? ProviderName { get; set; }

        /// <summary>
        /// Gets or sets the Provider id.
        /// </summary>
        public string? DepartmentId { get; set; }

        /// <summary>
        /// Gets or sets the Provider id.
        /// </summary>
        public int PatientAge { get; set; }

        /// <summary>
        /// Gets or sets the full name.
        /// </summary>
        public string? PatientName { get; set; }

        /// <summary>
        /// Gets or sets the father or husband.
        /// </summary>
        public string? FatherOrHusband { get; set; }

        /// <summary>
        /// Gets or sets the value.
        /// </summary>
        public string? AdmissionNo { get; set; }

        /// <summary>
        /// Gets or sets the follow up for appointment.
        /// </summary>
        public int? FollowUpForAppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the email.
        /// </summary>
        public int PatientId { get; set; }

        /// <summary>
        /// Gets or sets the mobile.
        /// </summary>
        public string? DepartmentName { get; set; }

        /// <summary>
        /// Gets or sets the umr no.
        /// </summary>
        public string? AppointmentNo { get; set; }

        /// <summary>
        /// Gets or sets the total amount.
        /// </summary>
        public long TotalAmount { get; set; }

        /// <summary>
        /// Gets or sets the country id.
        /// </summary>
        public int TotalAppointments { get; set; }

        /// <summary>
        /// Gets or sets the active.
        /// </summary>
        public bool? Active { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public string? VisitType { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public string? AppointmentDate { get; set; }

        /// <summary>
        /// Gets or sets the optional text 2.
        /// </summary>
        public string AppointmentTimeString { get; set; }

        /// <summary>
        /// Gets or sets the optional text 2.
        /// </summary>
        public TimeSpan AppointmentTime { get; set; }

        /// <summary>
        /// Gets or sets the optional text 2.
        /// </summary>
        public string AppointmentTimes { get; set; }
        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the patient mobile.
        /// </summary>
        public string Mobile { get; set; }

        /// <summary>
        /// Gets or sets the umr no.
        /// </summary>
        public string? UMRNo { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public string CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the role name.
        /// </summary>
        public string RoleName { get; set; }

        /// <summary>
        /// Gets or sets the referrred by.
        /// </summary>
        public string? ReferredBy { get; set; }

        /// <summary>
        /// Gets or sets the referrred by name.
        /// </summary>
        public string? ReferredByName { get; set; }

        /// <summary>
        /// Gets or sets the paymentType.
        /// </summary>
        public string? PaymentType { get; set; }



        /// <summary>
        /// Gets or sets the receipt id.
        /// </summary>
        public int? ReceiptId { get; set; }

        /// <summary>
        /// Gets or sets the receipt created by.
        /// </summary>
        public string? ReceiptCreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the street address.
        /// </summary>
        public string? StreetAdress { get; set; }
        /// <summary>
        /// Gets or sets the city.
        /// </summary>
        public string? City { get; set; }
        /// <summary>
        /// Gets or sets the state.
        /// </summary>
        public string? State { get; set; }
        /// <summary>
        /// Gets or sets the zipcode.
        /// </summary>
        public string? Zipcode { get; set; }

        /// <summary>
        /// Gets or sets the zipcode.
        /// </summary>
        public long TotAmt { get; set; }
        /// <summary>
        /// Gets or sets the zipcode.
        /// </summary>
        public string TotalAmountStr { get; set; }

        /// <summary>
        /// Gets or sets the payment transaction number.
        /// </summary>
        public string? PaymentNumber { get; set; }

        /// <summary>
        /// Gets or sets the name.
        /// </summary>
        public string? Name { get; set; }
        // <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime ReceiptDate { get; set; }
        /// <summary>
        /// Gets or sets the AppointmentTypeName.
        /// </summary>
        public string? AppointmentTypeName { get; set; }
        /// <summary>
        /// Gets or sets the appointmentTypeId.
        /// </summary>
        public int? AppointmentTypeId { get; set; }

        /// <summary>
        /// Gets or sets the payment status.
        /// </summary>
        public bool? PaymentStatus { get; set; }

        /// <summary>
        /// Gets or sets encounter type.
        /// </summary>
        public string? EncounterType { get; set; }

        /// <summary>
        /// Gets or sets the Appointment Status.
        /// </summary>
        public string? Status { get; set; }

        // <summary>
        /// Gets or sets the patient first name.
        /// </summary>
        public string? FirstName { get; set; }
        // <summary>
        /// Gets or sets the middle name.
        /// </summary>
        public string? MiddleName { get; set; }
        // <summary>
        /// Gets or sets the last name.
        /// </summary>
        public string? LastName { get; set; }

        /// <summary>
        /// Gets or sets the date of birth.
        /// </summary>

        public DateTime? DateOfBirth { get; set; }
        /// <summary>
        /// Gets or sets the Specialization Name.
        /// </summary>
        public string? SpecializationName { get; set; }

        /// <summary>
        ///  Gets or sets payment type Id for fetching 
        /// </summary>
        public char? TypeOfPayment { get; set; }
        public bool? IsHealthCard { get; set; }
    }
}
